# process_rois.r 
#
# Takes a list of one or more base filenames, and runs prepare_traces.r 

library(tidyverse)
library(here)

fname_list_hypoxia <- c(
  "20210414_14", 
  "20210419_2", 
  "20210419_5",
  "20210421_1", 
  "20210422_1", 
  "20210422_2", 
  "20210423_3", 
  "20210430_1", 
  "20210430_2", 
  "20210430_3", 
  "20210430_5", 
  "20210602_1", 
  "20210603_1", 
  "20210609_1"
)

fname_list_FCCP <- c(
  "20220718_3",
  "20220718_4",
  "20220729_1",
  "20220729_2",
  "20220729_3",
  "20220804_8",
  "20220811_2",
  "20220811_8",
  "20220811_16",
  "20220818_1",
  "20220818_3"
)

process_rois_hypoxia <- function(fname){
  print(fname)
  source(str_c(here(),"/source/prepare_traces_hypoxia.r"), local=TRUE)
}

fname_list_hypoxia %>% map(process_rois)

process_rois_FCCP <- function(fname){
  print(fname)
  source(str_c(here(),"/source/prepare_traces_FCCP.r"), local=TRUE)
}

fname_list_FCCP %>% map(process_rois)





